/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.dialogs.OpenCorpusDialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.BevelBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceOfTokensDigramsListener;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.CorpusEditorShell.TokensDigramsActionListener;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.Constants;
import net.nooj4nlp.engine.Indexkey;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Ntext;
import net.nooj4nlp.engine.helper.BackgroundWorker;
import net.nooj4nlp.gui.components.ColoredJButtonUI;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.InversiveSortActionListener;
import net.nooj4nlp.gui.dialogs.OpenCorpusDialog.TokensDigramsOnCloseEvents;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.DictionaryEditorShell;

public class TokensDigramsDialog
extends JInternalFrame
implements PropertyChangeListener {
    private static final long serialVersionUID = -4781752001731064151L;
    private JTable tableTokensDigrams;
    private JLabel label;
    private JButton btnClear;
    private JButton btnSelectAll;
    private JButton btnFilter;
    private JButton btnExport;
    private JButton btnLocateR;
    private JButton btnLocateG;
    private JButton btnLocateP;
    private JButton btnLocateB;
    private boolean isToken;
    private boolean isACorpus;
    private boolean reversedSortingActive = false;
    private int nbToks;
    private Ntext myText;
    private Language lan;
    private TextEditorShellController textController;

    public TokensDigramsDialog(TextEditorShellController textController, boolean isToken) {
        this.textController = textController;
        this.isACorpus = false;
        this.myText = textController.getMyText();
        this.lan = this.myText.Lan;
        this.isToken = isToken;
        String titleIndicator = isToken ? "Tokens" : "Digrams";
        this.setTitle(titleIndicator + " in " + textController.getTextName());
        this.setBounds(130, 130, 500, 450);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setClosable(true);
        this.getContentPane().setLayout((LayoutManager)new MigLayout("insets 3", "[30::][30::][30::][30::][30::][30::][30::][30::][30::, grow]", "[20!, grow][grow][30!, grow]"));
        this.label = new JLabel("New label");
        this.getContentPane().add((Component)this.label, "cell 0 0, span 9, alignx left,aligny top, height ::40");
        String label = "";
        label = isToken ? "Tokens" : "Digrams";
        DefaultTableModel tableModel = new DefaultTableModel(new Object[]{"Freq", label}, 0);
        this.tableTokensDigrams = new JTable(tableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tableTokensDigrams.setUI(new BasicTableUI(){

            @Override
            protected MouseInputListener createMouseInputListener() {
                return new BasicTableUI.MouseInputHandler(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() > 1) {
                            // empty if block
                        }
                    }
                };
            }
        });
        JScrollPane scrollPane1 = new JScrollPane(this.tableTokensDigrams);
        scrollPane1.setBorder(new BevelBorder(1, null, null, null, null));
        this.getContentPane().add((Component)scrollPane1, "cell 0 1, span 9, grow");
        this.btnClear = new JButton("Reset");
        this.getContentPane().add((Component)this.btnClear, "cell 0 2");
        this.btnClear.setActionCommand("Clear");
        this.btnSelectAll = new JButton("Select all");
        this.getContentPane().add((Component)this.btnSelectAll, "cell 1 2");
        this.btnSelectAll.setActionCommand("SelectAll");
        this.btnFilter = new JButton("Filter");
        this.getContentPane().add((Component)this.btnFilter, "cell 2 2");
        this.btnFilter.setActionCommand("Filter");
        this.btnExport = new JButton("Export");
        this.getContentPane().add((Component)this.btnExport, "cell 3 2");
        this.btnExport.setActionCommand("Export");
        this.btnLocateR = new JButton("N");
        this.btnLocateR.setUI(new ColoredJButtonUI(Constants.NOOJ_RED_BUTTON_COLOR, Constants.NOOJ_PRESSED_RED_BUTTON_COLOR));
        this.getContentPane().add((Component)this.btnLocateR, "cell 4 2");
        this.btnLocateG = new JButton("o");
        this.btnLocateG.setUI(new ColoredJButtonUI(Constants.NOOJ_GREEN_BUTTON_COLOR, Constants.NOOJ_PRESSED_GREEN_BUTTON_COLOR));
        this.getContentPane().add((Component)this.btnLocateG, "cell 5 2");
        this.btnLocateP = new JButton("o");
        this.btnLocateP.setUI(new ColoredJButtonUI(Constants.NOOJ_BLUE_BUTTON_COLOR, Constants.NOOJ_PRESSED_BLUE_BUTTON_COLOR));
        this.getContentPane().add((Component)this.btnLocateP, "cell 6 2");
        this.btnLocateB = new JButton("J");
        this.btnLocateB.setUI(new ColoredJButtonUI(Constants.NOOJ_GRAY_BUTTON_COLOR, Constants.NOOJ_PRESSED_GRAY_BUTTON_COLOR));
        this.getContentPane().add((Component)this.btnLocateB, "cell 7 2");
        TokensDigramsActionListener tdListener = new TokensDigramsActionListener(this, isToken);
        this.btnClear.addActionListener(tdListener);
        this.btnSelectAll.addActionListener(tdListener);
        this.btnFilter.addActionListener(tdListener);
        this.btnExport.addActionListener(tdListener);
        this.btnLocateR.addActionListener(new ConcordanceOfTokensDigramsListener(textController, this, this.tableTokensDigrams, isToken));
        this.btnLocateG.addActionListener(new ConcordanceOfTokensDigramsListener(textController, this, this.tableTokensDigrams, isToken));
        this.btnLocateP.addActionListener(new ConcordanceOfTokensDigramsListener(textController, this, this.tableTokensDigrams, isToken));
        this.btnLocateB.addActionListener(new ConcordanceOfTokensDigramsListener(textController, this, this.tableTokensDigrams, isToken));
        this.tableTokensDigrams.setAutoCreateRowSorter(false);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.tableTokensDigrams.getModel());
        sorter.setSortable(0, false);
        sorter.setSortable(1, false);
        this.tableTokensDigrams.setRowSorter(sorter);
        InversiveSortActionListener inversiveSort = new InversiveSortActionListener(this, this.reversedSortingActive, this.lan);
        this.tableTokensDigrams.getTableHeader().addMouseListener(inversiveSort);
        this.addInternalFrameListener(new TokensDigramsOnCloseEvents(this, inversiveSort));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            Launcher.getStatusBar().getProgressBar().setIndeterminate(false);
            Launcher.getStatusBar().getProgressBar().setValue(progress);
        }
    }

    public boolean isReversedSortingActive() {
        return this.reversedSortingActive;
    }

    public void setReversedSortingActive(boolean reversedSortingActive) {
        this.reversedSortingActive = reversedSortingActive;
    }

    public void fillInTheTokensDigramsTable(boolean isACorpus) {
        if (this.isToken) {
            HashMap<String, Indexkey> tokensDigramsHashTableText = this.myText.hTokens;
            this.fillInTextDataHelpFunction(tokensDigramsHashTableText, this.tableTokensDigrams, this.isToken);
            this.nbToks = tokensDigramsHashTableText.size();
        } else {
            HashMap<String, Indexkey> tokensDigramsHashTableText = this.myText.hDigrams;
            this.fillInTextDataHelpFunction(tokensDigramsHashTableText, this.tableTokensDigrams, this.isToken);
            this.nbToks = tokensDigramsHashTableText.size();
        }
        if (this.isToken) {
            this.label.setText(this.nbToks + " different tokens.");
        } else {
            this.label.setText(this.tableTokensDigrams.getModel().getRowCount() + " reoccurring digrams / " + this.nbToks);
        }
    }

    public void fillInTheData() {
        if (this.isToken) {
            this.label.setText("Tokens in: " + this.textController.getTextName());
            this.tokenization();
        } else {
            this.label.setText("Reoc. Digrams in Text: " + this.textController.getTextName());
            this.digramization();
        }
    }

    private void tokenization() {
        if (Launcher.backgroundWorking) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "One process is already running.", "NooJ: one process only in this version", 0);
            return;
        }
        Launcher.initialDate = new Date();
        if (this.isVisible()) {
            this.hide();
        }
        this.textController.desactivateOps();
        Launcher.getStatusBar().getBtnCancel().setEnabled(true);
        Launcher.getStatusBar().getBtnCancel().setForeground(Color.red);
        Launcher.progressMessage = "Tokenization...";
        Launcher.getStatusBar().getProgressLabel().setText("Tokenization...");
        Launcher.backgroundWorking = true;
        Launcher.backgroundWorker = new BackgroundWorker("text tokenization", this.textController, null);
        Launcher.backgroundWorker.addPropertyChangeListener(this);
        Launcher.backgroundWorker.execute();
        this.textController.computeTokens();
        this.fillInTheTokensDigramsTable(this.isACorpus);
        this.textController.reactivateOps();
        this.textController.updateTextPaneStats();
        this.textController.rtbTextUpdate(false);
        this.textController.modify();
        this.show();
        Date now = new Date();
        long sec = (now.getTime() - Launcher.initialDate.getTime()) / 1000L;
        Launcher.getStatusBar().getProgressLabel().setText(Long.toString(sec) + " sec");
    }

    private void digramization() {
        if (Launcher.backgroundWorking) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "One process is already running.", "NooJ: one process only in this version", 0);
            return;
        }
        Launcher.initialDate = new Date();
        if (this.isVisible()) {
            this.hide();
        }
        this.textController.desactivateOps();
        Launcher.getStatusBar().getBtnCancel().setEnabled(true);
        Launcher.getStatusBar().getBtnCancel().setForeground(Color.red);
        Launcher.progressMessage = "Indexing Digrams...";
        Launcher.getStatusBar().getProgressLabel().setText("Indexing Digrams...");
        if (Launcher.multithread) {
            Launcher.backgroundWorking = true;
            Launcher.backgroundWorker = new BackgroundWorker("text digramization", this.textController, null);
            Launcher.backgroundWorker.addPropertyChangeListener(this);
            Launcher.backgroundWorker.execute();
        } else {
            this.textController.computeDigrams();
            this.fillInTheTokensDigramsTable(this.isACorpus);
            this.textController.reactivateOps();
            this.textController.updateTextPaneStats();
            this.textController.rtbTextUpdate(false);
            this.textController.modify();
            this.show();
            Date now = new Date();
            long sec = (now.getTime() - Launcher.initialDate.getTime()) / 1000L;
            Launcher.getStatusBar().getProgressLabel().setText(Long.toString(sec) + " sec");
        }
    }

    public void fillTheDictionary() {
        DictionaryEditorShell editor = new DictionaryEditorShell();
        String lang = "";
        lang = this.textController.getMyText().LanguageName;
        editor.getController().initLoad(lang);
        String textLabel = this.isToken ? "TOKEN" : "DIGRAM";
        JTextPane textPane = editor.getTextPane();
        StringBuilder builder = new StringBuilder(textPane.getText());
        builder.append("\n");
        DefaultTableModel model = (DefaultTableModel)this.tableTokensDigrams.getModel();
        int rowCount = model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            builder.append(model.getValueAt(i, 1));
            builder.append("," + textLabel + "+Freq=");
            builder.append(model.getValueAt(i, 0));
            builder.append("\n");
        }
        textPane.setText(builder.toString());
        Launcher.getDesktopPane().add(editor);
        editor.setVisible(true);
    }

    private void fillInCorpusDataHelpFunction(HashMap<String, Integer> dataTable, JTable previewTable, boolean isToken) {
        DefaultTableModel tableModel = (DefaultTableModel)previewTable.getModel();
        tableModel.getDataVector().removeAllElements();
        Set<String> keys = dataTable.keySet();
        Object[] keysArray = keys.toArray();
        for (int i = 0; i < keysArray.length; ++i) {
            String token = keysArray[i].toString();
            Integer freq = dataTable.get(token.toString());
            tableModel = (DefaultTableModel)previewTable.getModel();
            Object[] obj = new Object[]{freq, token.toString()};
            tableModel.addRow(obj);
        }
    }

    private void fillInTextDataHelpFunction(HashMap<String, Indexkey> dataTable, JTable previewTable, boolean isToken) {
        DefaultTableModel tableModel = (DefaultTableModel)previewTable.getModel();
        tableModel.getDataVector().removeAllElements();
        for (String token : dataTable.keySet()) {
            Indexkey indexkey = dataTable.get(token.toString());
            int freq = indexkey.addresses.size() / 2;
            if (!isToken && freq < 2) continue;
            tableModel = (DefaultTableModel)previewTable.getModel();
            Object[] obj = new Object[]{freq, token.toString()};
            tableModel.addRow(obj);
        }
    }

    public void locateOneText(String fileName, Color c, ConcordanceShellController concordanceController) {
        HashMap<String, Indexkey> theTokensDigrams;
        JTable tokensDigramsTable;
        String textBuffer = this.myText.buffer;
        if (this.isToken) {
            tokensDigramsTable = this.textController.getTextShell().getTokensDialog().tableTokensDigrams;
            theTokensDigrams = this.myText.hTokens;
        } else {
            tokensDigramsTable = this.textController.getTextShell().getDigramsDialog().tableTokensDigrams;
            theTokensDigrams = this.myText.hDigrams;
        }
        int[] selectedDigrams = tokensDigramsTable.getSelectedRows();
        int selectedDigramsLength = selectedDigrams.length;
        for (int k = 0; k < selectedDigramsLength; ++k) {
            selectedDigrams[k] = tokensDigramsTable.convertRowIndexToModel(selectedDigrams[k]);
        }
        DefaultTableModel tableModel = (DefaultTableModel)tokensDigramsTable.getModel();
        if (selectedDigramsLength > 0) {
            for (int i = 0; i < selectedDigramsLength; ++i) {
                String digram = tableModel.getValueAt(selectedDigrams[i], 1).toString();
                if (!theTokensDigrams.containsKey(digram)) continue;
                Indexkey key = theTokensDigrams.get(digram);
                for (int j = 0; j < key.addresses.size(); j += 2) {
                    int absoluteBeginAddress = key.addresses.get(j);
                    int absoluteEndAddress = key.addresses.get(j + 1);
                    if (absoluteEndAddress == absoluteBeginAddress) {
                        if (Language.isLetter(textBuffer.charAt(absoluteBeginAddress))) {
                            for (absoluteEndAddress = absoluteBeginAddress; absoluteEndAddress < textBuffer.length() && Language.isLetter(textBuffer.charAt(absoluteEndAddress)); ++absoluteEndAddress) {
                            }
                        } else {
                            ++absoluteEndAddress;
                        }
                    }
                    concordanceController.AddData(this.myText, fileName, c, -1, absoluteBeginAddress, absoluteEndAddress, null, false, "Selected Tokens");
                }
            }
        } else {
            if (TokensDigramsDialog.allAnotationsNegativeConfirmation()) {
                return;
            }
            for (int i = 0; i < tokensDigramsTable.getRowCount(); ++i) {
                String digram = tableModel.getValueAt(i, 1).toString();
                if (!theTokensDigrams.containsKey(digram)) continue;
                Indexkey key = theTokensDigrams.get(digram);
                for (int j = 0; j < key.addresses.size(); j += 2) {
                    int absoluteBeginAddress = key.addresses.get(j);
                    int absoluteEndAddress = key.addresses.get(j + 1);
                    if (absoluteEndAddress == absoluteBeginAddress) {
                        if (Language.isLetter(textBuffer.charAt(absoluteBeginAddress))) {
                            for (absoluteEndAddress = absoluteBeginAddress; absoluteEndAddress < textBuffer.length() && Language.isLetter(textBuffer.charAt(absoluteEndAddress)); ++absoluteEndAddress) {
                            }
                        } else {
                            ++absoluteEndAddress;
                        }
                    }
                    concordanceController.AddData(this.myText, fileName, c, -1, absoluteBeginAddress, absoluteEndAddress, null, false, "Selected Tokens");
                }
            }
        }
    }

    private static boolean allAnotationsNegativeConfirmation() {
        String messageBoxText = "You did not choose specific tokens from the list. This operation may take a long time to complete. \n\nAre you sure you want to proceed? ";
        int answer = JOptionPane.showConfirmDialog(Launcher.getDesktopPane(), messageBoxText, "Confirm dialog", 0);
        return answer != 0;
    }

    public boolean isACorpus() {
        return this.isACorpus;
    }

    public JTable getTableTokensDigrams() {
        return this.tableTokensDigrams;
    }

    public void setMyText(Ntext myText) {
        this.myText = myText;
    }

    public Ntext getMyText() {
        return this.myText;
    }

    public TextEditorShellController getTextController() {
        return this.textController;
    }

    public boolean isToken() {
        return this.isToken;
    }
}

